<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Permission extends Model 
{

    protected $table = 'permissions';
    public $timestamps = true;
    protected $fillable = array('name', 'display_name', 'description', 'visibility_status', 'module_id');

    public function permission_used()
    {
        return $this->hasOne('App\Models\PermissionUsed', 'permission_id');
    }

    public function permission_module()
    {
        return $this->hasOne('App\Models\PermissionModule', 'module_id');
    }

}